import type { Config } from "tailwindcss";

const config: Config = {
  content: [
    "./src/pages/**/*.{js,ts,jsx,tsx,mdx}",
    "./src/components/**/*.{js,ts,jsx,tsx,mdx}",
    "./src/app/**/*.{js,ts,jsx,tsx,mdx}",
  ],
  theme: {
    container: () => ({
      center: true,
      padding: {
        DEFAULT: "1rem",
        sm: "1.25rem",
        lg: "1.75rem",
        xl: "2.25rem",
        "2xl": "3rem",
      },
    }),
    extend: {
      backgroundImage: {
        "gradient-radial": "radial-gradient(var(--tw-gradient-stops))",
        "gradient-conic":
          "conic-gradient(from 180deg at 50% 50%, var(--tw-gradient-stops))",
      },
      colors: {
        primary: {
          400: "#00badf",
          500: "#00badf",
          600: "#00badf",
        },
        secondary: {
          400: "#2FB8D7",
          500: "#01779A",
          600: "#01779A",
        },
        tertiary: {
          300: "#d8d8d8",
          500: "#939598",
        },
        page: "#f7f7f7",
      },
      padding: {
        section: "3.5rem",
      },
      fontFamily: {
        cairo: ["__Cairo_0d96cb"],
      },
      aspectRatio: {
        "3/2": "3/2",
      },
    },
  },
  plugins: [],
};
export default config;
