"use client";
import { Swiper, SwiperSlide } from "swiper/react";
import { Navigation, Autoplay, Pagination } from "swiper/modules";
import "swiper/css";
import "swiper/css/navigation";
import "swiper/css/pagination";
import { LeftArrow, RightArrow } from "@/components/icons/Arrow";
import styles from "./Slider.module.css";
import React from "react";

type Breakpoints = {
  [key: string | number]: {
    slidesPerView: number;
    loop?: boolean;
  };
};

type SliderProps = {
  children: React.ReactNode;
  loop?: boolean;
  autoplay?: boolean;
  navigation?: boolean;
  breakpoints?: Breakpoints;
  slidesPerView?: number;
  spaceBetween?: number;
  fullWidth?: boolean;
  grabCursor?: boolean;
  pagination?: boolean;
  onSlideChange?: () => void;
};

const defaultBreakPoints: Breakpoints = {
  1440: {
    slidesPerView: 4,
  },
  992: {
    slidesPerView: 3,
  },
  576: {
    slidesPerView: 2,
  },
};
export default function Slider({
  children,
  breakpoints,
  slidesPerView,
  spaceBetween = 20,
  autoplay = false,
  loop = false,
  fullWidth = false,
  navigation = true,
  grabCursor = true,
  pagination = false,
  onSlideChange,
}: SliderProps) {
  if (!slidesPerView && !breakpoints) breakpoints = defaultBreakPoints;

  return (
    <div className="relative max-h-full">
      <div
        className={`${!fullWidth ? `container ${styles.sliderContainer}` : ""}`}
      >
        <Swiper
          onSlideChange={() => onSlideChange?.()}
          className="!static"
          slidesPerView={slidesPerView}
          loop={loop}
          modules={[Navigation, Autoplay, Pagination]}
          breakpoints={breakpoints}
          autoplay={autoplay}
          spaceBetween={spaceBetween}
          navigation={
            navigation && {
              nextEl: ".swiper-button-next",
              prevEl: ".swiper-button-prev",
            }
          }
          pagination={pagination && { clickable: true }}
          grabCursor={grabCursor}
        >
          {navigation && (
            <>
              <div className="swiper-button-prev">
                <LeftArrow />
              </div>
              <div className="swiper-button-next">
                <RightArrow />
              </div>
            </>
          )}
          {React.Children.map(children, (child) => (
            <SwiperSlide>{child}</SwiperSlide>
          ))}
        </Swiper>
      </div>
    </div>
  );
}
