import { OrderInputs } from "@/types/OrderInputs";

type FormFieldProps = {
  placeholder?: string;
  type?: string;
  className?: string;
  handleChange?: (
    e: React.ChangeEvent<HTMLInputElement | HTMLTextAreaElement>,
  ) => void;
  value: string;
  error?: OrderInputs;
  name: keyof OrderInputs;
  as?: React.ElementType;
};
export default function FormField({
  placeholder = "",
  type,
  className = "",
  handleChange,
  error,
  name,
  as,
}: FormFieldProps) {
  const Component = as || "input";
  return (
    <div>
      <Component
        className={`w-full rounded-md border border-s-4 border-slate-300 py-3 ps-5 shadow-sm  placeholder:text-slate-400 focus:border-secondary-500 focus:outline-none focus:ring-1 focus:ring-secondary-500 ${className}`}
        placeholder={placeholder}
        type={type}
        onChange={(
          e: React.ChangeEvent<HTMLInputElement | HTMLTextAreaElement>,
        ) => handleChange?.(e)}
      />
      {error && error[name] && (
        <p className="mt-2 text-sm text-red-700">{error[name]}</p>
      )}
    </div>
  );
}
